//
//  TTTAudioViewController.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 10/29/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTAudioViewController.h"

@interface TTTAudioViewController (){
    AVAudioRecorder *localRecorder;
    AVAudioPlayer *localPlayer;
    AVAudioPlayer *localRecordPlayer;
    NSURL *playFileURL;
    NSURL *recordFileURL;
}

@end

@implementation TTTAudioViewController
    @synthesize playButton;
    @synthesize stopPlayingButton;
    @synthesize recordButton;
    @synthesize stopRecordingButton;
    @synthesize playRecordingButton;
    @synthesize stopPlayingRecordingButton;


    - (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil{
        self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
        if (self) {
            // Custom initialization
        }
        return self;
    }

    - (void)viewDidLoad{
        [super viewDidLoad];
        // Do any additional setup after loading the view.
        localRecorder = nil;
        localPlayer = nil;
        localRecordPlayer = nil;
        playFileURL = nil;
        recordFileURL = nil;
        [[AVAudioSession sharedInstance] setCategory:AVAudioSessionCategoryPlayAndRecord error:nil];
    }

    - (void)didReceiveMemoryWarning{
        [super didReceiveMemoryWarning];
        // Dispose of any resources that can be recreated.
    }

    - (IBAction) play:(id)sender{
        if (playFileURL == nil){
            NSString* audioPath =[[NSBundle mainBundle] pathForResource:@"Audio.bundle/SampleAudio-Cut" ofType:@"mp3"];
            playFileURL = [NSURL fileURLWithPath:audioPath];
        }

        localPlayer = [[AVAudioPlayer alloc] initWithContentsOfURL:playFileURL error:nil];
        [localPlayer setDelegate:self];
        [localPlayer play];
    }

    - (void) audioPlayerDidFinishPlaying:(AVAudioPlayer *)player successfully:(BOOL)flag{
        NSLog(@"Done playing!");
    }

    - (IBAction) stopPlaying:(id)sender{
        [localPlayer stop];
    }

    - (IBAction) record:(id)sender{
        NSLog(@"In record\n");
        // Set the record file
    
        NSArray *pathComponents = [NSArray arrayWithObjects:
                                   [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) lastObject],
                                   @"TicTacToeRecordingTest.m4a",
                                   nil];
        recordFileURL = [NSURL fileURLWithPathComponents:pathComponents];
    

        // Initiate and prepare the recorder
        // Define the recorder setting

        NSMutableDictionary *recordSettings = [[NSMutableDictionary alloc] init];

        [recordSettings setValue:[NSNumber numberWithInt:kAudioFormatMPEG4AAC] forKey:AVFormatIDKey];
        [recordSettings setValue:[NSNumber numberWithFloat:44100.0] forKey:AVSampleRateKey];
        [recordSettings setValue:[NSNumber numberWithInt: 2] forKey:AVNumberOfChannelsKey];

    
        localRecorder = [[AVAudioRecorder alloc] initWithURL:recordFileURL settings:recordSettings error:nil];
        localRecorder.delegate = self;
        localRecorder.meteringEnabled = YES;
        [localRecorder prepareToRecord];
        [localRecorder record];
    }

    - (void) audioRecorderDidFinishRecording:(AVAudioRecorder *)avrecorder successfully:(BOOL)flag{
        NSLog(@"Done recording!");
    }

    - (IBAction) stopRecording:(id)sender{
        NSLog(@"In stopRecording\n");
        [localRecorder stop];
    }

    - (IBAction) playRecording:(id)sender{
        NSLog(@"In playRecording\n");
        NSLog(@"Audio file URL >%@<", localRecorder.url);
        localRecordPlayer = [[AVAudioPlayer alloc] initWithContentsOfURL:localRecorder.url error:nil];
        [localRecordPlayer setDelegate:self];
        [localRecordPlayer play];

    }

    - (IBAction) stopPlayingRecording:(id)sender{
        NSLog(@"In stopPlayingRecording\n");
        [localRecordPlayer stop];
    }

    - (IBAction) exit:(id)sender{
        [self dismissViewControllerAnimated:YES completion:nil];
    }

@end
